/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.managers.interfaces;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IMysticalSite;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRegisteredStructureManager {
    public void read(@NotNull CompoundNBT var1);

    public void write(@NotNull CompoundNBT var1);

    public void clearDirty();

    public void sendPackets(Set<ServerPlayerEntity> var1, Set<ServerPlayerEntity> var2);

    public void onColonyTick(IColony var1);

    public void cleanUpBuildings(IColony var1);

    public IBuilding getBuilding(BlockPos var1);

    public List<BlockPos> getLeisureSites();

    @Nullable
    public BlockPos getFirstBuildingMatching(Predicate<IBuilding> var1);

    public void addLeisureSite(BlockPos var1);

    public void removeLeisureSite(BlockPos var1);

    @Nullable
    public IWareHouse getClosestWarehouseInColony(BlockPos var1);

    @NotNull
    public Map<BlockPos, IBuilding> getBuildings();

    public ITownHall getTownHall();

    public int getMysticalSiteMaxBuildingLevel();

    public boolean hasWarehouse();

    public boolean hasMysticalSite();

    public boolean hasTownHall();

    @Nullable
    public <B extends IBuilding> B getBuilding(BlockPos var1, @NotNull Class<B> var2);

    @NotNull
    public List<BlockPos> getFields();

    public void addNewField(AbstractScarecrowTileEntity var1, BlockPos var2, World var3);

    @Nullable
    public AbstractScarecrowTileEntity getFreeField(int var1, World var2);

    public void removeBuilding(@NotNull IBuilding var1, Set<ServerPlayerEntity> var2);

    public void markBuildingsDirty();

    @Nullable
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding var1, World var2);

    public void removeField(BlockPos var1);

    public BlockPos getBestBuilding(AbstractEntityCitizen var1, Class<? extends IBuilding> var2);

    public BlockPos getBestBuilding(BlockPos var1, Class<? extends IBuilding> var2);

    public BlockPos getRandomBuilding(Predicate<IBuilding> var1);

    public boolean hasGuardBuildingNear(IBuilding var1);

    public void guardBuildingChangedAt(IBuilding var1, int var2);

    public void setTownHall(@Nullable ITownHall var1);

    public void removeWareHouse(IWareHouse var1);

    public List<IWareHouse> getWareHouses();

    public void removeMysticalSite(IMysticalSite var1);

    public List<IMysticalSite> getMysticalSites();

    public boolean canPlaceAt(Block var1, BlockPos var2, PlayerEntity var3);

    public boolean isWithinBuildingZone(Chunk var1);

    public IBuilding getHouseWithSpareBed();

    public void onBuildingUpgradeComplete(@Nullable IBuilding var1, int var2);

    public BlockPos getRandomLeisureSite();
}

